/////////////////////////////////////////////////////////////////////

BOOL SetupServerSettings(BOOL Yes_No)
{
	//--------------------------------------------------------------------------------

	if(Runing_NT_2K_XP)
	{
		if(Yes_No == TRUE)
		{
			short ServiceInstalled = xIsServiceInstalled();

			SetDWORDValue(HKEY_CLASSES_ROOT,ServiceRegistryKey,"ServiceSetup",1);

			if(ServiceInstalled == _No_ )
			{
				if ( xInstallService() == _Success_ )
				{
					MessageBox( NULL, "XService was installed sucessfully !", TitleCaption, MB_ICONINFORMATION );
					xStartService();
					return 0;
				}
				else{
					MessageBox( NULL, "Service installed Failed !", TitleCaption, MB_ICONINFORMATION );
					ShellExecute(0,"Open",ServerApp,"~NonService",NULL,SW_SHOWNORMAL);
					return 0;
				}
			}

			if( ServiceInstalled == _Yes_ )
			{
				xStartService();
				return 0;
			}

			return TRUE;
		}

		if(Yes_No == FALSE)
		{
			ShellExecute(0,"Open",ServerApp,"~NonService",NULL,SW_SHOWNORMAL);
			SetDWORDValue(HKEY_CLASSES_ROOT,ServiceRegistryKey,"ServiceSetup",2);
			return TRUE;
		}
	}

	//--------------------------------------------------------------------------------

	if(Running98ME)
	{
		if(Yes_No == TRUE) // Create Windows 98/ME Startup
		{
			unsigned long SizeOfBuffer = MaxPath;
			char StartUp[MaxPath];
			char SourceFileName[MaxPath];
			char TargetFileName[MaxPath];

			if(!GetStringValue(HKEY_CURRENT_USER,ShellFolders,"Startup",StartUp,SizeOfBuffer))
				return FALSE;

			GetModuleFileName(MainInstance,SourceFileName,MaxPath);
			sprintf(TargetFileName,"%s\\%s",StartUp,"HttpServer.Lnk");
			ShortCut(SourceFileName,TargetFileName);

			ShellExecute(0,"Open",ServerApp,"~NonService",NULL,SW_SHOWNORMAL);
			SetDWORDValue(HKEY_CLASSES_ROOT,ServiceRegistryKey,"ServiceSetup",2);
			return TRUE;
		}

		if(Yes_No == FALSE)
		{
			ShellExecute(0,"Open",ServerApp,"~NonService",NULL,SW_SHOWNORMAL);
			SetDWORDValue(HKEY_CLASSES_ROOT,ServiceRegistryKey,"ServiceSetup",2);
			return TRUE;
		}
	}

	//--------------------------------------------------------------------------------

	if( Runing95 )
	{
		if(Yes_No == TRUE)
		{
			ShellExecute(0,"Open",ServerApp,"~NonService",NULL,SW_SHOWNORMAL);
			SetDWORDValue(HKEY_CLASSES_ROOT,ServiceRegistryKey,"ServiceSetup",2);
			return TRUE;
		}

		if(Yes_No == FALSE) return TRUE;
	}

	//--------------------------------------------------------------------------------

	if( RuningOther )
	{
		if(Yes_No == TRUE)
		{
			ShellExecute(0,"Open",ServerApp,"~NonService",NULL,SW_SHOWNORMAL);
			SetDWORDValue(HKEY_CLASSES_ROOT,ServiceRegistryKey,"ServiceSetup",2);
			return TRUE;
		}

		if(Yes_No == FALSE) return TRUE;
	}

	//--------------------------------------------------------------------------------

	return TRUE;
}

/////////////////////////////////////////////////////////////////////

BOOL GetOSSettings(HWND TextBox_hWnd)
{
	char *xBuffer = NULL;
	DWORD dwVersion = 0;
	OSVERSIONINFO OS;
	OS.dwOSVersionInfoSize = sizeof(OS);
	dwVersion = GetVersion();
	xBuffer = (char *) calloc(MaxPath,1);

	if(GetVersionEx(&OS))
	{
		if(OS.dwPlatformId == 1)
		{
			if(OS.dwMinorVersion == 0)
			{
				sprintf(xBuffer, "Windows 95 %d.%d (Build %d) %s\r\n\r\n",LOBYTE(LOWORD(dwVersion)),HIBYTE(LOWORD(dwVersion)),OS.dwBuildNumber & 0xFFFF,OS.szCSDVersion);
				TextBoxWrite(TextBox_hWnd,xBuffer);
				TextBoxWrite(TextBox_hWnd,"Your Operating System Is Not Supported By The Server.\r\n\r\n");
				TextBoxWrite(TextBox_hWnd,"Would You Like To Attempt To Run The Server Anyway?\r\n");
				Runing95 = TRUE;
				return TRUE;
			}

			if(OS.dwMinorVersion == 10)
			{
				sprintf(xBuffer, "Windows 98 %d.%d (Build %d) %s\r\n\r\n",LOBYTE(LOWORD(dwVersion)),HIBYTE(LOWORD(dwVersion)),OS.dwBuildNumber & 0xFFFF,OS.szCSDVersion);
				TextBoxWrite(TextBox_hWnd,xBuffer);
				TextBoxWrite(TextBox_hWnd,"Your Operating System Is Partially Supported By The Server.\r\n\r\n");
				TextBoxWrite(TextBox_hWnd,"Would You Like To Run The Server At Startup?\r\n");
				Running98ME = TRUE;
				return TRUE;
			}

			if(OS.dwMinorVersion == 90)
			{
				sprintf(xBuffer, "Windows ME %d.%d (Build %d) %s\r\n\r\n",LOBYTE(LOWORD(dwVersion)),HIBYTE(LOWORD(dwVersion)),OS.dwBuildNumber & 0xFFFF,OS.szCSDVersion);
				TextBoxWrite(TextBox_hWnd,xBuffer);
				TextBoxWrite(TextBox_hWnd,"Your Operating System Is Partially Supported By The Server.\r\n\r\n");
				TextBoxWrite(TextBox_hWnd,"Would You Like To Run The Server At Startup?\r\n");
				Running98ME = TRUE;
				return TRUE;
			}
		}

		if(OS.dwPlatformId == 2)
		{
			if(OS.dwMajorVersion == 3)
			{
				sprintf(xBuffer, "Windows NT %d.%d (Build %d) %s\r\n\r\n",LOBYTE(LOWORD(dwVersion)),HIBYTE(LOWORD(dwVersion)),OS.dwBuildNumber & 0xFFFF,OS.szCSDVersion);
				TextBoxWrite(TextBox_hWnd,xBuffer);
				TextBoxWrite(TextBox_hWnd,"Your Operating System Is Fully Supported By The Server.\r\n\r\n");
				TextBoxWrite(TextBox_hWnd,"Would You Like To Run The Server As A Windows NT Service?\r\n");
				Runing_NT_2K_XP = TRUE;
				return TRUE;
			}
			if(OS.dwMajorVersion == 4)
			{
				sprintf(xBuffer, "Windows NT %d.%d (Build %d) %s\r\n\r\n",LOBYTE(LOWORD(dwVersion)),HIBYTE(LOWORD(dwVersion)),OS.dwBuildNumber & 0xFFFF,OS.szCSDVersion);
				TextBoxWrite(TextBox_hWnd,xBuffer);
				TextBoxWrite(TextBox_hWnd,"Your Operating System Is Fully Supported By The Server.\r\n\r\n");
				TextBoxWrite(TextBox_hWnd,"Would You Like To Run The Server As A Windows NT Service?\r\n");
				Runing_NT_2K_XP = TRUE;
				return TRUE;
			}
			if(OS.dwMajorVersion == 5 && OS.dwMinorVersion == 0)
			{
				sprintf(xBuffer, "Windows 2000 %d.%d (Build %d) %s\r\n\r\n",LOBYTE(LOWORD(dwVersion)),HIBYTE(LOWORD(dwVersion)),OS.dwBuildNumber & 0xFFFF,OS.szCSDVersion);
				TextBoxWrite(TextBox_hWnd,xBuffer);
				TextBoxWrite(TextBox_hWnd,"Your Operating System Is Fully Supported By The Server.\r\n\r\n");
				TextBoxWrite(TextBox_hWnd,"Would You Like To Run The Server As A Windows 2000 Service?\r\n");
				Runing_NT_2K_XP = TRUE;
				return TRUE;
			}
			if(OS.dwMajorVersion == 5 && OS.dwMinorVersion == 1)
			{
				sprintf(xBuffer, "Windows XP %d.%d (Build %d) %s\r\n\r\n",LOBYTE(LOWORD(dwVersion)),HIBYTE(LOWORD(dwVersion)),OS.dwBuildNumber & 0xFFFF,OS.szCSDVersion);
				TextBoxWrite(TextBox_hWnd,xBuffer);
				TextBoxWrite(TextBox_hWnd,"Your Operating System Is Fully Supported By The Server.\r\n\r\n");
				TextBoxWrite(TextBox_hWnd,"Would You Like To Run The Server As A Windows XP Service?\r\n");
				Runing_NT_2K_XP = TRUE;
				return TRUE;
			}

		}
	}

	if( (!Runing_NT_2K_XP) && (!Running98ME) )
	{
		TextBoxWrite(TextBox_hWnd,"Your Operating System Could Not Be Determined.\r\n\r\n");
		TextBoxWrite(TextBox_hWnd,"Would You Like To Attempt To Run The Server Anyway?\r\n");
		RuningOther = TRUE;
	}

	return TRUE;
}

/////////////////////////////////////////////////////////////////////

HRESULT CreateLink (LPCSTR FileName, LPSTR LinkName, LPSTR Description)
{
	HRESULT  hResult;
	memset(&hResult,0,sizeof(hResult));

	IShellLink *ShellLinkPointer;
	memset(&ShellLinkPointer,0,sizeof(ShellLinkPointer));

	// Added this line to initialize the COM object unsure if it is right
	CoInitialize(NULL);

	// Get a pointer to the IShellLink interface.
	hResult = CoCreateInstance(CLSID_ShellLink,NULL,CLSCTX_INPROC_SERVER,IID_IShellLink,(LPVOID *)&ShellLinkPointer);
	if((SUCCEEDED(hResult)))
	{
		IPersistFile *PersistFilePointer;
		memset(&PersistFilePointer,0,sizeof(PersistFilePointer));

		/* Set the path to the shortcut target, and add the description. */

		ShellLinkPointer->SetPath(FileName);
		ShellLinkPointer->SetDescription(Description);

		/* Query IShellLink for the IPersistFile interface for saving the
		 shortcut in persistent storage. */

		hResult = ShellLinkPointer->QueryInterface( IID_IPersistFile, (LPVOID *) &PersistFilePointer);

		if((SUCCEEDED(hResult)))
		{
			WORD Word[MAX_PATH];
			memset(&Word,0,sizeof(Word));

			// Ensure that the string is ANSI.
			MultiByteToWideChar(CP_ACP,0,LinkName,-1,Word,MAX_PATH);

			// Save the link by calling IPersistFile::Save.
			hResult = PersistFilePointer->Save(Word,TRUE);
			PersistFilePointer->Release();
		}

		ShellLinkPointer->Release();
	}
	CoUninitialize();
	return hResult;
}

/////////////////////////////////////////////////////////////////////

BOOL ShortCut(char *FileName, char *LinkName)
{
	//CreateLink(FileName,LinkName,Description);
	if( SUCCEEDED(CreateLink(FileName,LinkName,"")) )
		return TRUE;
		else return FALSE;
}

/////////////////////////////////////////////////////////////////////

